package cn.com.duiba.activity.center.api.mqmessage;

import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * @author: zhengjianhao
 * @date: 2019/1/29 11:51
 * @description:
 */
public class ShuQiUpdateReadTimeMessage implements Serializable{

    private static final long serialVersionUID = -6352838651519125420L;

    private Boolean lastSync;

    private Long teamId;

    private Long recordDate;

    private String redisKey;

    public Boolean getLastSync() {
        return lastSync;
    }

    public void setLastSync(Boolean lastSync) {
        this.lastSync = lastSync;
    }

    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public Long getRecordDate() {
        return recordDate;
    }

    public void setRecordDate(Long recordDate) {
        this.recordDate = recordDate;
    }

    public String getRedisKey() {
        return redisKey;
    }

    public void setRedisKey(String redisKey) {
        this.redisKey = redisKey;
    }

    public static ShuQiUpdateReadTimeMessage decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return JSONObject.parseObject(string, ShuQiUpdateReadTimeMessage.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(ShuQiUpdateReadTimeMessage msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
