package cn.com.duiba.activity.center.api.dto.activity;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 集卡规则
 * Created by xiaoxuda on 2017/10/25.
 */
public class CLRuleDto extends BaseDto {
    private static final long serialVersionUID = -7772885025439495421L;

    /**
     * 规则数据类型，留待后续扩展使用
     */
    private String type;
    /**
     * 规则数据ID
     */
    @NotNull(message = "规则数据ID不能为null")
    private Long id;
    /**
     * 规则名称
     */
    @NotBlank(message = "规则名称不能为空")
    private String name;
    /**
     * 关联title
     */
    private String title;
    /**
     * 展示图
     */
    @NotBlank(message = "展示图不能为空")
    private String img;
    /**
     * 命中规则时的展示图
     */
    @NotBlank(message = "命中规则时的展示图不能为空")
    private String selImg;
    /**
     * 属性key  值参考
     * CLRewardRuleTypeEnum 类
     */
    private String properyKey;
    /**
     * 属性值
     */
    private String properyVal;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public String getSelImg() {
        return selImg;
    }

    public void setSelImg(String selImg) {
        this.selImg = selImg;
    }
    public String getProperyKey() {
        return properyKey;
    }

    public void setProperyKey(String properyKey) {
        this.properyKey = properyKey;
    }

    public String getProperyVal() {
        return properyVal;
    }

    public void setProperyVal(String properyVal) {
        this.properyVal = properyVal;
    }
}
