package cn.com.duiba.activity.center.api.dto.seedredpacket;

import java.io.Serializable;

/**
 * @author zhengjianhao
 * @date 18/7/5
 * @description 地块信息
 */
public class LandInfoDto implements Serializable {

	private static final long serialVersionUID = 4798928023460001083L;

	/**
	 * 土地顺序id：1，2，3，4，5，6，7，8
	 */
	private Long landId;

	/**
	 * 土地状态：1，不可解锁；2，可解锁；3，空地；4，有红包
	 * @see cn.com.duiba.activity.center.api.enums.LandStatusEnum
	 */
	private Integer landStatus;

	/**
	 * 红包id
	 */
	private String redPacketId;

	/**
	 * 红包金额
	 */
	private Long amount;

	/**
	 * 红包种植时间戳（以毫秒为单位）
	 */
	private Long seedTime;

	/**
	 * 红包成熟所需时间（以秒为单位）
	 */
	private Long grownNeedTime;

	/**
	 * 解锁任务当前完成值
	 */
	private Long latestValue;

	/**
	 * 解锁任务目标值
	 */
	private Integer targetValue;

	/**
	 * 解锁任务类型
	 * @see cn.com.duiba.activity.center.api.enums.SeedRedPacketLandTaskTypeEnum
	 */
	private Integer taskType;

	public Long getLatestValue() {
		return latestValue;
	}

	public void setLatestValue(Long latestValue) {
		this.latestValue = latestValue;
	}

	public Integer getTargetValue() {
		return targetValue;
	}

	public void setTargetValue(Integer targetValue) {
		this.targetValue = targetValue;
	}

	public Integer getTaskType() {
		return taskType;
	}

	public void setTaskType(Integer taskType) {
		this.taskType = taskType;
	}

	public Long getLandId() {
		return landId;
	}

	public void setLandId(Long landId) {
		this.landId = landId;
	}

	public Integer getLandStatus() {
		return landStatus;
	}

	public void setLandStatus(Integer landStatus) {
		this.landStatus = landStatus;
	}

	public String getRedPacketId() {
		return redPacketId;
	}

	public void setRedPacketId(String redPacketId) {
		this.redPacketId = redPacketId;
	}

	public Long getAmount() {
		return amount;
	}

	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public Long getSeedTime() {
		return seedTime;
	}

	public void setSeedTime(Long seedTime) {
		this.seedTime = seedTime;
	}

	public Long getGrownNeedTime() {
		return grownNeedTime;
	}

	public void setGrownNeedTime(Long grownNeedTime) {
		this.grownNeedTime = grownNeedTime;
	}
}
