package cn.com.duiba.activity.center.api.enums;

/**
 * 种红包土地解锁任务类型
 * 0:无 1:连续登录天数 2:累计种植次数 3:累计消耗积分数 4:用户兑换次数
 */
public enum SeedRedPacketLandTaskTypeEnum {

    NONE(0, "无限制"),
    LOGIN(1, "连续登录天数"),
    TOTAL_PLANTING(2, "累计种植次数"),
    TOTAL_CREDITS(3, "累计消耗积分数"),
    TOTAL_EXCHANGE(4, "用户兑换次数"),
    ;

    private Integer code;
    private String desc;

    SeedRedPacketLandTaskTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
