package cn.com.duiba.activity.center.api.remoteservice.offlineissuance;

import cn.com.duiba.activity.center.api.domain.dto.offlineissuance.OfflineIssuanceMechanismDto;
import cn.com.duiba.activity.center.api.domain.dto.offlineissuance.OfflineIssuanceReceiveRecordDto;

import java.util.Date;
import java.util.List;

import cn.com.duiba.api.bo.page.Page;

import cn.com.duiba.activity.center.api.domain.dto.offlineissuance.QueryMechanismDto;
import cn.com.duiba.activity.center.api.domain.dto.offlineissuance.QueryReceiveRecordDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteOfflineIssuanceReceiveRecordService {

	Integer save(OfflineIssuanceReceiveRecordDto offlineIssuanceReceiveRecordDto) throws BizException;

    void deleteById(Long id) throws BizException;

    void deleteBatchByIds(List<Long> ids) throws BizException;

    Integer updateById(OfflineIssuanceReceiveRecordDto offlineIssuanceReceiveRecordDto) throws BizException;

    OfflineIssuanceReceiveRecordDto getById(Long id) throws BizException;

    List<OfflineIssuanceReceiveRecordDto> listByIds(List<Long> ids) throws BizException;

    /**
     * 分页查询领取记录
     * @param startTime
     * @param endTime
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<OfflineIssuanceReceiveRecordDto> listReceiveRecordByPage(Date startTime, Date endTime, Integer pageNo, Integer pageSize);

    /**
     * 根据时间和id范围查询
     * @param appId
     * @param startTime
     * @param endTime
     * @param id
     * @param pageSize
     * @return
     */
    List<OfflineIssuanceReceiveRecordDto> listReceiveRecordByIdLimit(Long appId, Date startTime, Date endTime, Long id, Integer pageSize);

    /**
     * 分页查询领取记录
     * @param queryReceiveRecordDto
     * @return
     */
    Page<OfflineIssuanceReceiveRecordDto> pageReceiveRecord(QueryReceiveRecordDto queryReceiveRecordDto);
}
