package cn.com.duiba.activity.center.api.remoteservice.joingroup;

import cn.com.duiba.activity.center.api.dto.joingroup.JoinGroupInfoDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhengjianhao
 * @date 18/9/14
 * @description 团信息
 */
@AdvancedFeignClient
public interface RemoteJoinGroupInfoAppService {

	/**
	 * 新增团
	 */
	Long add(JoinGroupInfoDto entity);

	/**
	 * 拼团成功
	 */
	int modifyToSuccess(Long id, Long winConsumerId);

	/**
	 * 拼团失败，加回库存
	 */
	void modifyToFailure(List<Long> ids);

	/**
	 * 按拼团id获取团信息
	 */
	JoinGroupInfoDto getById(Long id);

	/**
	 * 按拼团id列表批量获取拼团信息
	 */
	List<JoinGroupInfoDto> getByIdList(List<Long> idList);

	/**
	 * 按拼团商品id和状态批量获取团信息
	 */
	List<JoinGroupInfoDto> getByItemIdAndStatus(Long appId, Long joinGroupItemId, Integer status);

    /**
     * 按拼团商品id列表和状态批量获取团信息
     *
     * @param joinGroupItemIds 商品id列表
     * @param status           状态
     * @return
     */
    List<JoinGroupInfoDto> getByItemIdsAndStatus(Long appId, List<Long> joinGroupItemIds, Integer status);

	/**
	 * 按appId、拼团活动配置id、状态批量获取团信息
	 */
	List<JoinGroupInfoDto> getByAppConfigIdAndStatus(Long appId, Long joinGroupConfigId, Integer status, Integer otherGroupCount, Long groupId);
}
