/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.tool;

import cn.com.duiba.activity.center.api.dto.flow.ActivityFlowRuleDto;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityFlowRuleParseUtil {
    private static final Logger log = LoggerFactory.getLogger(ActivityFlowRuleParseUtil.class);

    public static List<Long> parseActivityIds(String activityIds) {
        if (StringUtils.isBlank((CharSequence)activityIds)) {
            return Collections.emptyList();
        }
        try {
            List ids = JSONObject.parseArray((String)activityIds, Long.class);
            if (CollectionUtils.isEmpty((Collection)ids)) {
                return Collections.emptyList();
            }
            return ids;
        }
        catch (Exception e) {
            log.error("json error, src={}", (Object)activityIds, (Object)e);
            return Collections.emptyList();
        }
    }

    public static Set<String> parseRegions(String regions) {
        if (StringUtils.isBlank((CharSequence)regions)) {
            return null;
        }
        try {
            List regionList = JSONObject.parseArray((String)regions, String.class);
            return new HashSet<String>(regionList);
        }
        catch (Exception e) {
            log.error("json error, src={}", (Object)regions, (Object)e);
            return null;
        }
    }

    public static Map<Integer, List<ActivityFlowRuleDto.Period>> parsePeriods(String periods) {
        if (StringUtils.isBlank((CharSequence)periods)) {
            return null;
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)periods);
            if (jsonObject == null) {
                return null;
            }
            HashMap<Integer, List<ActivityFlowRuleDto.Period>> ret = new HashMap<Integer, List<ActivityFlowRuleDto.Period>>();
            for (String key : jsonObject.keySet()) {
                ret.put(Integer.valueOf(key), JSONObject.parseArray((String)jsonObject.getString(key), ActivityFlowRuleDto.Period.class));
            }
            return ret;
        }
        catch (Exception e) {
            log.error("json error, src={}", (Object)periods, (Object)e);
            return null;
        }
    }

    public static List<Long> parseActivityIdsAllowNull(String activityIds) {
        if (StringUtils.isBlank((CharSequence)activityIds)) {
            return null;
        }
        try {
            List ids = JSONObject.parseArray((String)activityIds, Long.class);
            if (CollectionUtils.isEmpty((Collection)ids)) {
                return Collections.emptyList();
            }
            return ids;
        }
        catch (Exception e) {
            log.error("json error, src={}", (Object)activityIds, (Object)e);
            return Collections.emptyList();
        }
    }
}

