package cn.com.duiba.activity.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 抽签工具表DTO
 * 
 * @author cgq
 * @date 2025-01-19
 */
@Data
public class LotteryToolDto implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 主键ID
     */
    private Long id;
    
    /**
     * 是否删除,1-已删除;0-未删除
     */
    private Integer isDeleted;
    
    /**
     * 创建时间
     */
    private Date gmtCreate;
    
    /**
     * 修改时间
     */
    private Date gmtModified;
    
    /**
     * 抽奖状态：0 等待抽奖，1 抽奖中 2 抽奖成功 3抽奖失败 4待发码 5发码中
     * @see cn.com.duiba.activity.center.api.enums.LotteryToolStatusEnum
     */
    private Integer prizeDrawStatus;
    
    /**
     * 商品id
     */
    private Long appItemId;
    
    /**
     * 扫描时间
     */
    private Date scanTime;
    
    /**
     * 深圳成指指数
     */
    private String shenzhenComponentIndex;
    
    /**
     * 中小100指数
     */
    private String zhongxiaOneHundredIndex;
    
    /**
     * 中签配额
     */
    private Long winningBidQuota;
    
    /**
     * A：基数
     */
    private Long baseNumber;
    
    /**
     * B：翻转数
     */
    private Long flipNumber;
    
    /**
     * X：总次数
     */
    private Long totalCount;
    
    /**
     * Z：阶数
     */
    private Long orderLevel;
    
    /**
     * 创建人id
     */
    private Long createOperatorId;
    
    /**
     * 创建人姓名
     */
    private String createOperatorName;
    
    /**
     * 实际中签人数
     */
    private Long actualWinningCount;
} 