package cn.com.duiba.activity.center.api.enums.alipayactivityredpack;

import java.util.Arrays;
import java.util.Objects;

public enum RedActivitySourceEnum {
    /**
     * 渠道
     */
    JI_GAO("jigao", "继皋", "WET_PAYMKTTRANS")
    ;

    /**
     * 渠道code
     */
    private String channel;

    /**
     * 描述文案
     */
    private String desc;

    /**
     * 商家编码
     */
    private String merchantCode;

    RedActivitySourceEnum(String channel, String desc, String merchantCode) {
        this.channel = channel;
        this.desc = desc;
        this.merchantCode = merchantCode;
    }

    public static RedActivitySourceEnum getEnumByActivityChannel(String channel) {
        return Arrays.stream(RedActivitySourceEnum.values()).filter(item -> Objects.equals(item.getChannel(), channel)).findFirst().orElse(null);
    }

    public String getChannel() {
        return channel;
    }

    public String getDesc() {
        return desc;
    }

    public String getMerchantCode() {
        return merchantCode;
    }
}
