package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 绑定记录状态 定制使用
 **/
public enum EquityVerifyStatuEnum {


    WAIT_COMFIRE(1, "待确认"),

    CAN_VERIFYs(2, "可核销"),
    ;
    private Integer code;
    private String desc;

    EquityVerifyStatuEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EquityVerifyStatuEnum ofValue(Integer code) {
        for (EquityVerifyStatuEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

