package cn.com.duiba.activity.center.api.remoteservice.offlineissuance;

import cn.com.duiba.activity.center.api.domain.dto.offlineissuance.OfflineIssuanceMechanismDto;
import java.util.List;

import cn.com.duiba.activity.center.api.domain.dto.offlineissuance.QueryMechanismDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteOfflineIssuanceMechanismService {

	Integer save(OfflineIssuanceMechanismDto offlineIssuanceMechanismDto) throws BizException;

    void deleteById(Long id) throws BizException;

    void deleteBatchByIds(List<Long> ids) throws BizException;

    Integer updateById(OfflineIssuanceMechanismDto offlineIssuanceMechanismDto) throws BizException;

    OfflineIssuanceMechanismDto getById(Long id) throws BizException;

    List<OfflineIssuanceMechanismDto> listByIds(List<Long> ids) throws BizException;

    /**
     * 分页查询机构
     * @param queryMechanismDto
     * @return
     */
    Page<OfflineIssuanceMechanismDto> pageMechanism(QueryMechanismDto queryMechanismDto);

    /**
     * 新建机构
     * @param offlineIssuanceMechanismDto
     * @return
     * @throws BizException 业务异常 机构号或名称重复
     */
    Boolean saveMechanism(OfflineIssuanceMechanismDto offlineIssuanceMechanismDto) throws BizException;

    /**
     * 开启/禁用机构
     * @param appId
     * @param mechanismNo
     * @param mechanismStatus
     * @return
     */
    Boolean enableOrDisable(Long appId, String mechanismNo, Integer mechanismStatus);

    /**
     * 根据机构号批量查询
     * @param mechanismNos
     * @return
     */
    List<OfflineIssuanceMechanismDto> listByMechanismNos(List<String> mechanismNos);

    /**
     * 根据appId和机构号查询
     * @param appId
     * @param mechanismNo
     * @return
     */
    OfflineIssuanceMechanismDto getByAppIdAndMechanismNo(Long appId, String mechanismNo);

}
