package cn.com.duiba.activity.center.api.dto.wanda;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * 万达供销存订单取消记录查询DTO
 */
@Data
public class WandaOrderCancelRecordQueryDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 应用ID，标识调用来源系统（必填）
     */
    private Long appId;

    /**
     * 平台订单号
     */
    private String orderNum;

    /**
     * 开发者订单号（外部订单号）
     */
    private String developerBizId;

    /**
     * 用户ID
     */
    private String partnerUserId;

    /**
     * 商品名称
     */
    private String itemTitle;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 页码，默认为1
     */
    private Integer pageNo = 1;

    /**
     * 每页数量，默认为10
     */
    private Integer pageSize = 10;
}