package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaTaxTicketRecordDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaTaxTicketRecordQueryDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 万达开票记录远程服务接口
 */
@AdvancedFeignClient
public interface RemoteWandaTaxTicketRecordService {

    /**
     * 分页查询开票记录列表
     */
    Page<WandaTaxTicketRecordDto> pageQueryTaxTicketRecord(WandaTaxTicketRecordQueryDto queryDto);

    /**
     * 根据ID查询开票记录
     */
    WandaTaxTicketRecordDto queryTaxTicketRecordById(Long id);

    /**
     * 根据订单号查询单条记录
     */
    WandaTaxTicketRecordDto queryTaxTicketRecordByOrderNum(String orderNum);

    /**
     * 单个创建开票记录
     */
    Long createTaxTicketRecord(WandaTaxTicketRecordDto dto);

    /**
     * 根据ID更新开票记录
     */
    Boolean updateTaxTicketRecord(WandaTaxTicketRecordDto dto);
}