package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 库存操作枚举
 **/
public enum StockOptEnum {

    ADD(1, "增加"),
    SUB(2, "减少"),
    ;
    private Integer code;
    private String desc;

    StockOptEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static StockOptEnum ofValue(Integer code) {
        for (StockOptEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

