package cn.com.duiba.activity.center.api.remoteservice.equitycard;

import cn.com.duiba.activity.center.api.dto.equitycard.EquityCardPayRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;

/**
 * @author zhangdaqing
 * @Description
 * @date 2023/9/15 17:05
 */
@AdvancedFeignClient
public interface RemoteEquityCardPayRecordService {

    int insertPayRecord(EquityCardPayRecordDto record);

    /**
     * 统计支付的人数
     *
     * @param configId
     * @return int
     */
    int countPayRecordByConfigId(Long configId);

    /**
     * @param userId
     * @param configId
     * @param time
     * @return {@link EquityCardPayRecordDto}
     */
    EquityCardPayRecordDto getPayRecordByUserAndTime(String userId, Long configId, Date time);


    EquityCardPayRecordDto getLastPayRecordByUserId(String userId, Long configId);


    Long updatePayRecord(EquityCardPayRecordDto record);

    void deleteById(Long id);

    EquityCardPayRecordDto getRecordByUserIdAndBizId(String userId, String bizId);


}
