package cn.com.duiba.activity.center.api.enums;

/**
 * 抽签工具状态枚举
 * 
 * @author cqg
 * @date 2025-01-19
 */
public enum LotteryToolStatusEnum {
    
    WAITING(0, "等待抽奖"),
    DRAWING(1, "抽奖中"),
    SUCCESS(2, "抽奖成功"),
    FAILED(3, "抽奖失败"),
    WAIT_SEND_CODE(4, "待发码"),
    SENDING_CODE(5, "发码中"),
    EXPIRED(6, "已过期");

    private Integer code;
    private String desc;

    LotteryToolStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据状态码获取枚举
     * 
     * @param code 状态码
     * @return 枚举值
     */
    public static LotteryToolStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (LotteryToolStatusEnum status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
} 