package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.EquityXiAnGiftPackDto;
import cn.com.duiba.activity.center.api.request.equity.XiAnGiftPackRequest;
import cn.com.duiba.activity.center.api.request.equity.XiAnGiftPackStockRequest;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author haojiahong
 * @date 2021-08-25
 */
@AdvancedFeignClient
public interface RemoteEquityXiAnGiftPackService {

    /**
     * 通过权益id，查询此权益下的礼包集合
     *
     * @param equityId
     * @return
     */
    List<EquityXiAnGiftPackDto> listByEquityId(Long equityId);

    /**
     * 通过礼包id，查询此礼包
     *
     * @param packId
     * @return
     */
    List<EquityXiAnGiftPackDto> listByPackId(String packId);

    /**
     * 通过商品id集合查询礼包
     *
     * @param appItemIdList
     * @return
     */
    List<EquityXiAnGiftPackDto> listByAppItemIds(List<Long> appItemIdList);

    /**
     * 删除某个权益下的所有礼包
     *
     * @param equityId
     * @return
     */
    Integer deleteByEquityId(Long equityId);

    /**
     * 新增or更新权益礼包
     *
     * @param equityId
     * @param requestList
     * @return
     */
    Integer saveOrUpdateXiAnGiftPack(Long equityId, List<XiAnGiftPackRequest> requestList);


    /**
     * b端保存某个权益礼包库存
     *
     * @param request
     * @return
     */
    Boolean saveXiAnGiftPackStock(XiAnGiftPackStockRequest request);

    /**
     * c端用户使用权益礼包库存
     *
     * @param packId
     * @return
     */
    Boolean useXiAnGiftPackStock(String packId);



    /**
     * 通过权益id集合，查询此权益下的礼包集合
     *
     * @param equityIdList
     * @return
     */
    List<EquityXiAnGiftPackDto> listByEquityIds(List<Long> equityIdList);

}
