package cn.com.duiba.activity.center.api.remoteservice.newgamecenter;

import cn.com.duiba.activity.center.api.dto.newgamecenter.SeasonConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/09/04
 */
@AdvancedFeignClient
public interface RemoteSeasonConfigService {
    /**
     * 通过appId获取赛季信息
     * @param appId appId
     * @return SeasonConfigDto
     */
    SeasonConfigDto findByAppId(Long appId);

    /**
     * 获取赛季信息
     * @param id seasonConfigId
     * @return SeasonConfigDto
     */
    SeasonConfigDto findById(Long id);

    /**
     * 根据appId查询当前app当月所有赛季配置信息红包总额
     * @param appId
     * @return
     */
    Long findAllCurrentMonthSeasonConfigDtoByAppId(Long appId);
}
