package cn.com.duiba.activity.center.api.request.equity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author linzhou
 * @Description:
 * @date 2019/12/2611:35 上午
 */
public class StationStockBatchRequest implements Serializable {

    private static final long serialVersionUID = -2686487437992277384L;

    private Long appId;

    private Long appItemId;


    private Map<Long, Integer> stationId2StockNum;
    /**
     * 网点库存id
     */
    private Long stationStockId;


    public Long getStationStockId() {
        return stationStockId;
    }

    public void setStationStockId(Long stationStockId) {
        this.stationStockId = stationStockId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Map<Long, Integer> getStationId2StockNum() {
        return stationId2StockNum;
    }

    public void setStationId2StockNum(Map<Long, Integer> stationId2StockNum) {
        this.stationId2StockNum = stationId2StockNum;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getAllStockNum() {
        if (stationId2StockNum == null || stationId2StockNum.isEmpty()) {
            return null;
        }
        Integer rlt = 0;

        for (Integer stockNum : stationId2StockNum.values()) {
            if (stockNum != null && stockNum > 0) {
                rlt += stockNum;
            }
        }
        return rlt;
    }

    public List<Long> getStationIds(){
        if (stationId2StockNum == null){
            return new ArrayList<>();
        }
        return new ArrayList<>(stationId2StockNum.keySet());
    }
}
