package cn.com.duiba.activity.center.api.enums;

/**
 * ClassName:BookTypeEnum.java <br/>
 * 书旗金龙奖阶段枚举类
 *
 * @author xukaiqiang
 * @version 1.0
 * @date 创建时间：2018年06月13日 上午10:02:54
 * @since JDK 1.8
 */
public enum KingPrizeStageEnum {

    COLLECT_STAGE(1, "投稿阶段"),
    BALLOT_STAGE(2, "投票阶段"),
    PRIZE_STAGE(3, "开奖阶段"),
    OPEN_PRIZE_STAGE(4,"待开奖");

    private Integer value;

    private String desc;

    KingPrizeStageEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static KingPrizeStageEnum getStage(Long current,Long start,Long end) {
        if(current<=start){
            return KingPrizeStageEnum.COLLECT_STAGE;
        }else if(start<current&&current<=end){
            return KingPrizeStageEnum.BALLOT_STAGE;
        }else{
            return KingPrizeStageEnum.PRIZE_STAGE;
        }
    }

}
