package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * 签到数据来源
 * Created by xiaoxuda on 2017/5/31.
 */
public enum SignSourceTypeEnum {
    UNIFORM(1, "统一签到"),
    SIGN_SYSTEM(2, "签到体系签到");

    private static Map<Integer, SignSourceTypeEnum> typeEnumMap = new HashMap<>();

    static {
        for (SignSourceTypeEnum typeEnum : SignSourceTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }


    private Integer code;
    private String desc;


    SignSourceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 通过code获取签到来源类型
     *
     * @param code
     * @return
     */
    public static SignSourceTypeEnum getByCode(int code) {
        SignSourceTypeEnum type = typeEnumMap.get(code);
        if(type == null){
            throw new ActivityCenterException("不支持的签到来源");
        }
        return type;
    }

}
