package cn.com.duiba.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Hd抽奖次数远程服务接口
 */
@AdvancedFeignClient
public interface RemoteDrawTimesService {


    /**
     * 查询用户有效的抽奖次数总和
     *
     * @param appId      应用id
     * @param opId       活动id
     * @param consumerId 用户id
     * @return 有效的抽奖次数总和
     */
    Long getValidDrawTimes(Long appId, Long opId, Long consumerId);

    /**
     * 消耗抽奖次数
     *
     * @param appId      应用id
     * @param opId       活动id
     * @param consumerId 用户id
     * @return 是否消耗成功
     */
    boolean consumeDrawTimes(Long appId, Long opId, Long consumerId);

    /**
     * 增加今日抽奖次数
     *
     * @param appId      应用id
     * @param opId       活动id
     * @param consumerId 用户id
     * @param times      增加的次数
     * @return 是否成功
     */
    boolean addDayDrawTimes(Long appId, Long opId, Long consumerId, Long times);

    /**
     * 增加永久抽奖次数
     *
     * @param appId      应用id
     * @param opId       活动id
     * @param consumerId 用户id
     * @param times      增加的次数
     * @return 是否成功
     */
    boolean addForeverDrawTimes(Long appId, Long opId, Long consumerId, Long times);
}