package cn.com.duiba.activity.center.api.enums.pyramidspread;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/04/19 11:04.
 */
public enum PyramidSpreadNewRewardTypeEnum {
    TYPE_FIXED(0, "固定数值"),
    TYPE_REGION(1, "随机区间"),
    ;

    private static final ImmutableMap<Integer, PyramidSpreadNewRewardTypeEnum> ALL_MAP;
    static {
        Map<Integer, PyramidSpreadNewRewardTypeEnum> temp = Maps.newHashMap();
        for(PyramidSpreadNewRewardTypeEnum enumVal: PyramidSpreadNewRewardTypeEnum.values()) {
            temp.put(enumVal.getType(), enumVal);
        }
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    public static PyramidSpreadNewRewardTypeEnum getByType(Integer type) {
        return ALL_MAP.get(type);
    }

    private int type;
    private String desc;

    PyramidSpreadNewRewardTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
