package cn.com.duiba.activity.center.api.params.hsbc;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @Author: fss
 * @Date: 2022/5/16 10
 * @Description:
 */
public class HsbcTaskQueryParams implements Serializable {

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * appID
     */
    private Long appId;

    /**
     * 活动ID
     */
    private Long operatingActivityId;

    /**
     * 页码
     */
    private Integer pageNum;

    /**
     * 页数据量
     */
    private Integer pageSize;

    /**
     * 查询时间
     */
    private Date startDate;

    private Date endDate;

    private Integer offset;

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        if (Objects.nonNull(pageNum) && Objects.nonNull(pageSize)) {
            return (pageNum - 1) * pageSize;
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }
}
