package cn.com.duiba.activity.center.api.remoteservice;

import cn.com.duiba.activity.center.api.dto.HdTaskConfigDto;
import cn.com.duiba.activity.center.api.dto.SaveHdTaskParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Hd任务配置远程服务接口
 *
 * @author duiba
 * @date 2024-02-27
 */
@AdvancedFeignClient
public interface RemoteTaskConfigService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    HdTaskConfigDto getById(Long id);

    /**
     * 根据任务code查询配置
     *
     * @param taskCode 任务code
     * @param appId    应用id
     * @param opId     活动id
     * @return 实例对象
     */
    HdTaskConfigDto getByTaskCode(String taskCode, Long appId, Long opId);

    /**
     * 根据appId和opId查询所有配置
     *
     * @param appId 应用id
     * @param opId  活动id
     * @return 对象列表
     */
    List<HdTaskConfigDto> listByAppIdAndOpId(Long appId, Long opId);

    /**
     * 批量新增数据
     *
     * @param dtoList List<HdTaskConfigDto> 实例对象列表
     * @return 是否成功
     */
    boolean saveBatch(List<HdTaskConfigDto> dtoList);

    /**
     * 批量修改数据
     *
     * @param dtoList List<HdTaskConfigDto> 实例对象列表
     * @return 是否成功
     */
    boolean updateBatch(List<HdTaskConfigDto> dtoList);

    /**
     * 批量删除数据
     *
     * @param ids 需要删除的ID列表
     * @return 是否成功
     */
    boolean removeBatch(List<Long> ids);

    /**
     * 保存或更新任务配置
     * 根据appId和opId对比已有配置:
     * 1. 不存在的id则新增
     * 2. 已存在的id则更新
     * 3. 已存在但不在入参中的则删除
     * @return 是否成功
     */
    boolean saveOrUpdateTaskConfig(SaveHdTaskParam param);
}