package cn.com.duiba.activity.center.api.remoteservice.creditsfarm;


import cn.com.duiba.activity.center.api.dto.creditsfarm.CreditsFarmCropDetailDto;
import cn.com.duiba.activity.center.api.dto.creditsfarm.CropDetailQueryParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * created by liugq in 2019/08/05
 * 种植流水服务
 */
@AdvancedFeignClient
public interface RemoteCreditsFarmCropDetailService {

    Integer updateById(CreditsFarmCropDetailDto dto);

    Long insert(CreditsFarmCropDetailDto dto);

    /**
     * 根据扣积分订单号查询
     * @param orderNum
     * @return
     */
    CreditsFarmCropDetailDto findByOrderNum(String orderNum);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    CreditsFarmCropDetailDto findById(Long id);

    List<CreditsFarmCropDetailDto> selectByCondition(CropDetailQueryParam param);

    /**
     * 得到扣积分处理结果后的业务处理
     */
    @Deprecated
    Boolean dealAfterSubCreditsCallBack(String orderNum, Boolean success);
    /**
     * 得到扣积分处理结果后的业务处理
     */
    Boolean dealAfterSubCreditsCallBackNew(Long id,String orderNum, Boolean success);

    /**
     * 收获
     * @param dto 种植记录
     * @return
     */
    Integer gain(CreditsFarmCropDetailDto dto) ;

    /**
     * 是否有未收取的种植
     * @param consumerId
     * @param actId
     * @param zoneNo : 可为空
     * @return
     */
    Integer countByCondition(Long consumerId, Long actId, Integer zoneNo);

    /**
     * 加速
     * @param consumerId
     * @param actId
     * @param speedTime
     * @throws BizException
     */
    void speed(Long consumerId, Long actId, Long speedTime);

    /**
     * 加速
     * 查询用户当前所有未成熟的种植记录id
     * @param consumerId
     * @param actId
     * @return
     */
    List<Long> selectNotMatureId(Long consumerId, Long actId);
}
