package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.DisGoodsDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaDisGoodsDto;
import cn.com.duiba.activity.center.api.params.wanda.EditGroggeryDisParam;
import cn.com.duiba.activity.center.api.params.wanda.QueryDisGoodsPageParam;
import cn.com.duiba.activity.center.api.params.wanda.QueryGroggerySingleDisGoodsPageParam;
import cn.com.duiba.activity.center.api.params.wanda.WandaDisGoodsParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 万达分销商品远程服务接口
 *
 * @author zhengzhihao
 */
@AdvancedFeignClient
public interface RemoteWandaDisGoodsService {
    /**
     * 根据分销类型和分销唯一编码得到 开发者商品id
     */
    Page<Long> listItemIdsPage(QueryDisGoodsPageParam param) throws BizException;

    /**
     * 查询酒店分销单品列表
     */
    Page<DisGoodsDto> listGroggerySinglePage(QueryGroggerySingleDisGoodsPageParam param) throws BizException;

    /**
     * 批量插入分销关系
     */
    Boolean batchInsertDisGoods(List<WandaDisGoodsParam> params) throws BizException;

    /**
     * 批量删除分销关系
     */
    Boolean batchDeleteByTypeAndUniqueCodes(Integer disType, List<String> disUniqueCodes);

    /**
     * 增量更新酒店分销商品关系
     * @param param 更新参数
     * @return 更新结果
     */
    Boolean incrementalUpdateDisGoods(EditGroggeryDisParam param) throws BizException;


    /**
     * 根据分销类型和分销唯一编码查询商品ID列表
     * @param disType 分销类型
     * @param disUniqueCode 分销唯一编码
     * @return 商品ID列表
     */
    List<Long> listItemIdsByTypeAndUniqueCode(Integer disType, String disUniqueCode);

    /**
     * 更新酒店分销单品的分销比例
     * @param id 主键ID
     * @param disRate 分销比例
     * @return 是否更新成功
     */
    Boolean updateGroggerySingleDisRate(Long id, Integer disRate);

    /**
     * 根据ID批量删除酒店分销单品
     * @param ids 主键ID
     * @return 是否删除成功
     */
    Boolean batchDeleteGroggerySingleDisItem(List<Long> ids);

    /**
     * 根据商品id分销类型和分销唯一编码查询分销记录id列表
     */
    List<Long> listDisRecordIdsByAppItemItemIdsAndTypeAndUniqueCodes(List<Long> appItemId, Integer disType, String disUniqueCodes);

    /**
     * 根据分销类型和分销唯一编码列表查询实体类列表
     * @param disType 分销类型
     * @param disUniqueCodes 分销唯一编码列表
     * @return DTO列表
     */
    List<WandaDisGoodsDto> listByTypeAndUniqueCodes(Integer disType, List<String> disUniqueCodes);

    /**
     * 根据分销类型、分销唯一编码和商品ID查询一条记录
     * @param disType 分销类型
     * @param disUniqueCode 分销唯一编码
     * @param appItemId 开发者商品ID
     * @return DTO，如果不存在则返回null
     */
    WandaDisGoodsDto getByTypeAndUniqueCodeAndItemId(Integer disType, String disUniqueCode, Long appItemId);
}
