package cn.com.duiba.activity.center.api.enums;

/**
 * Created by Liugq on 2018/12/21.
 * 红包广场奖励类型
 */
public enum LSBonusTypeEnum {
    BONUS_TYPE_MONEY(0, "红包"),
    BONUS_TYPE_CREDITS(1, "积分"),
    ;


    private Integer code;
    private String desc;

    LSBonusTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LSBonusTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (LSBonusTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
