package cn.com.duiba.activity.center.api.remoteservice.scraperedpacket;

import cn.com.duiba.activity.center.api.dto.scraperedpacket.ScrapeRedpacketDetailDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteScrapeRedPacketDetailService {

    Long insert(ScrapeRedpacketDetailDto dto);

    ScrapeRedpacketDetailDto findById(Long id);

    /**
     * 根据活动id及用户id查询
     *
     * @param activityId
     * @param consumerId
     * @return
     */
    List<ScrapeRedpacketDetailDto> selectByActIdAndCId(Long activityId, Long consumerId);

    /**
     * 更新红包进度，在原已邀请人数上+1
     *
     * @param id
     * @param inviteFriendsAgo
     * @return
     */
    boolean updateProgressById(Long id, int inviteFriendsAgo);

    /**
     * 回退红包收集完成状态至上一节点（缺少一名帮刮好友）
     *
     * @param id
     * @return
     */
    boolean updateCollectCompleteBackById(Long id);

    /**
     * 更新当前红包的刮刮码信息
     *
     * @param id
     * @param redPacketCode
     * @return
     */
    boolean updateRedPacketCodeById(Long id, String redPacketCode);

    /**
     * 更新红包详情的翻倍卡信息
     *
     * @param id
     * @param multipleCard
     * @return
     */
    boolean updateMultipleCardById(Long id, String multipleCard);

    /**
     * 更新红包状态至完成节点 -- 已领取
     *
     * @param id
     * @return
     */
    boolean updateCompleteById(Long id);

    /**
     * 入账失败，将红包的完成状态回滚至待领取状态
     *
     * @param id
     * @return
     */
    boolean updatePendReceiveById(Long id);
}
