package cn.com.duiba.activity.center.api.remoteservice.seckill;

import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillDto;
import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillStockDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;

import java.util.List;

/**
 * Created by wenqi.huang on 2016/11/21.
 */
@AdvancedFeignClient
public interface RemoteDuibaSeckillStockService {

    /**
     * 根据活动Id找库存
     * @param id
     * @return
     */
    public DuibaSeckillStockDto findBySeckillId(Long id);

    /**
     * 创建库存
     * @param seckillId
     * @throws BusinessException
     */
    @Deprecated
    public void createSeckillStock(Optional<Long> seckillId) throws BusinessException;


    public void createSeckillStockApi(Optional<Long> seckillId) throws BizException;

    /**
     * 修改总库存
     * @param seckillId
     * @param quantity
     * @throws BusinessException
     */
    @Deprecated
    public void editTotalStock(Long seckillId,Integer quantity) throws BusinessException;

    public void editTotalStockApi(Long seckillId,Integer quantity) throws BizException;

    /**
     * 
     * batchCreateStockConfig:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param seckillId
     * @param appIds
     * @throws BusinessException
     * @since JDK 1.6
     */
    @Deprecated
    public void batchCreateStockConfig(Long seckillId,List<Long> appIds) throws BusinessException;

    public void batchCreateStockConfigApi(Long seckillId,List<Long> appIds) throws BizException;

    /**
     * 
     * deleteStockConfig:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param seckillId
     * @param appId
     * @throws BusinessException
     * @since JDK 1.6
     */
    @Deprecated
    public void deleteStockConfig(Long seckillId,Long appId) throws BusinessException;

    public void deleteStockConfigApi(Long seckillId,Long appId) throws BizException;

    /**
     * 
     * saveTotalConfigs:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param seckillId
     * @param configList
     * @throws BusinessException
     * @since JDK 1.6
     */
    @Deprecated
    public void saveTotalConfigs(Long seckillId,List<JSONObject> configList) throws BusinessException;

    public void saveTotalConfigsApi(Long seckillId,List<JSONObject> configList) throws BizException;

    /**
     * 
     * flushConfigStock:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param seckill
     * @param needFlushDay
     * @since JDK 1.6
     */
    public void flushConfigStock(DuibaSeckillDto seckill, boolean needFlushDay);

}
