/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.rank;

import cn.com.duiba.activity.center.api.dto.ngame.SimpleConsumerRankDto;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public final class NGameRank {
    private static final long MAX_SCORE = 0x1FFBFFFFFFL;
    private static final long MIN_SCORE = -1L;
    private static final long MAX_TIME_SEQ = 0x4000000L;
    private static final BigDecimal CUT_PERCENTAGE = BigDecimal.valueOf(0.999);
    private String dataKey;
    private String lastRankKey;
    private String timeSepKey;
    private int dataKeyExpire;
    private boolean isDesc;
    private Integer rankLimit;
    private RedisTemplate<String, String> redisClient;

    NGameRank(String dataKey, String lastRankKey, String timeSepKey, int dataKeyExpire, boolean isDesc, Integer rankLimit, RedisTemplate<String, String> redisClient) {
        this.dataKey = dataKey;
        this.lastRankKey = lastRankKey;
        this.timeSepKey = timeSepKey;
        this.dataKeyExpire = dataKeyExpire;
        this.isDesc = isDesc;
        this.rankLimit = rankLimit;
        this.redisClient = redisClient;
    }

    public boolean add(String cid, long score) {
        long score5000 = this.getLimitRankScoreNew(this.redisClient);
        boolean needTime = this.isDesc ? score > score5000 : score < score5000;
        double nScore = this.getTimeScore(score, this.getTimeSeqNew(needTime));
        Boolean ret = this.redisClient.opsForZSet().add((Object)this.dataKey, (Object)cid, nScore);
        this.redisClient.expire((Object)this.dataKey, (long)this.dataKeyExpire, TimeUnit.DAYS);
        Long count = this.redisClient.opsForZSet().size((Object)this.dataKey);
        if (count > (long)this.rankLimit.intValue()) {
            this.removeOutData(count);
        }
        return ret;
    }

    public BigDecimal percentage(Long rank) {
        try {
            if (rank == null) {
                return BigDecimal.ZERO;
            }
            Long count = this.redisClient.opsForZSet().zCard((Object)this.dataKey);
            if (count == null || count == 0L) {
                return BigDecimal.ZERO;
            }
            BigDecimal percentage = new BigDecimal(count - rank + 1L).divide(new BigDecimal(count), 6, RoundingMode.DOWN);
            if (percentage.compareTo(CUT_PERCENTAGE) > 0) {
                return percentage.setScale(4, RoundingMode.DOWN).movePointRight(2);
            }
            return percentage.setScale(4, RoundingMode.HALF_UP).movePointRight(2);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public Long getCount() {
        return this.redisClient.opsForZSet().zCard((Object)this.dataKey);
    }

    public List<SimpleConsumerRankDto> getConsumerRank(Integer count) {
        return this.findRankPage(0, count);
    }

    public List<SimpleConsumerRankDto> findRankPage(Integer start, Integer end) {
        ArrayList result = Lists.newArrayList();
        if (end == null) {
            return result;
        }
        Set set = this.isDesc ? this.redisClient.opsForZSet().reverseRangeWithScores((Object)this.dataKey, (long)start.intValue(), (long)end.intValue()) : this.redisClient.opsForZSet().rangeWithScores((Object)this.dataKey, (long)start.intValue(), (long)end.intValue());
        Iterator iterator = set.iterator();
        int rank = 0;
        while (iterator.hasNext()) {
            ++rank;
            ZSetOperations.TypedTuple temp = (ZSetOperations.TypedTuple)iterator.next();
            if (null == temp) continue;
            SimpleConsumerRankDto simpleConsumerRankDto = new SimpleConsumerRankDto();
            simpleConsumerRankDto.setConsumerId((String)temp.getValue());
            simpleConsumerRankDto.setMaxScoreStr(String.valueOf(this.getScore(temp.getScore())));
            simpleConsumerRankDto.setRank(String.valueOf(rank));
            result.add(simpleConsumerRankDto);
        }
        return result;
    }

    public Long getScore(String consumerId) {
        Long rank = this.getRank(consumerId);
        if (rank == null) {
            return null;
        }
        Long l = rank;
        rank = rank - 1L;
        Set set = this.isDesc ? this.redisClient.opsForZSet().reverseRangeWithScores((Object)this.dataKey, rank.longValue(), rank.longValue()) : this.redisClient.opsForZSet().rangeWithScores((Object)this.dataKey, rank.longValue(), rank.longValue());
        if (CollectionUtils.isEmpty((Collection)set)) {
            return null;
        }
        Iterator it = set.iterator();
        return this.getScore(((ZSetOperations.TypedTuple)it.next()).getScore());
    }

    public Long getScoreByRank(Integer rank) {
        if (rank == null) {
            return null;
        }
        Integer n = rank;
        rank = rank - 1;
        Set set = this.isDesc ? this.redisClient.opsForZSet().reverseRangeWithScores((Object)this.dataKey, (long)rank.intValue(), (long)rank.intValue()) : this.redisClient.opsForZSet().rangeWithScores((Object)this.dataKey, (long)rank.intValue(), (long)rank.intValue());
        if (CollectionUtils.isEmpty((Collection)set)) {
            return null;
        }
        Iterator it = set.iterator();
        return this.getScore(((ZSetOperations.TypedTuple)it.next()).getScore());
    }

    public Long getRank(String consumerId) {
        Long rawRank = this.isDesc ? this.redisClient.opsForZSet().reverseRank((Object)this.dataKey, (Object)consumerId) : this.redisClient.opsForZSet().rank((Object)this.dataKey, (Object)consumerId);
        return rawRank == null ? null : Long.valueOf(rawRank + 1L);
    }

    private void removeOutData(long count) {
        if (this.isDesc) {
            this.redisClient.opsForZSet().removeRange((Object)this.dataKey, 0L, count - (long)(this.rankLimit + 1));
        } else {
            this.redisClient.opsForZSet().removeRange((Object)this.dataKey, (long)this.rankLimit.intValue(), count);
        }
    }

    private double getTimeScore(long sc, long time) {
        if (sc > 0x1FFBFFFFFFL || sc < -1L) {
            sc = sc > 0x1FFBFFFFFFL ? 0x1FFBFFFFFFL : -1L;
        }
        long n = sc << 26;
        long last = n + time;
        return Double.longBitsToDouble(last);
    }

    private long getTimeSeqNew(boolean needTime) {
        if (!needTime) {
            return this.isDesc ? 0L : 0x4000000L;
        }
        long timeSeq = this.redisClient.opsForValue().increment((Object)this.timeSepKey, 1L);
        this.redisClient.expire((Object)this.timeSepKey, (long)this.dataKeyExpire, TimeUnit.DAYS);
        long l = timeSeq = timeSeq > 0x4000000L ? 0x4000000L : timeSeq;
        if (this.isDesc) {
            return 0x4000000L - timeSeq;
        }
        return timeSeq;
    }

    private long getLimitRankScoreNew(RedisTemplate<String, String> redisClient) {
        String score = (String)redisClient.opsForValue().get((Object)this.lastRankKey);
        if ((score = StringUtils.trim((String)score)) == null) {
            Set set;
            int index = this.rankLimit - 1;
            if (this.isDesc) {
                set = redisClient.opsForZSet().reverseRangeWithScores((Object)this.dataKey, (long)index, (long)index);
                if (set == null || set.size() == 0) {
                    score = String.valueOf(-1L);
                }
            } else {
                set = redisClient.opsForZSet().rangeWithScores((Object)this.dataKey, (long)index, (long)index);
                if (set == null || set.size() == 0) {
                    score = String.valueOf(0x1FFBFFFFFFL);
                }
            }
            if (score == null) {
                Iterator it = set.iterator();
                score = String.valueOf(this.getScore(((ZSetOperations.TypedTuple)it.next()).getScore()));
            }
            redisClient.opsForValue().set((Object)this.lastRankKey, (Object)score, 30L, TimeUnit.SECONDS);
        }
        try {
            return Long.valueOf(score);
        }
        catch (NumberFormatException e) {
            return 1L;
        }
    }

    private long getScore(double timeScore) {
        return Double.doubleToLongBits(timeScore) >> 26;
    }

    public void update(String cid, Long totalScore) {
        if (StringUtils.isBlank((String)cid) || totalScore == null) {
            return;
        }
        this.clean(cid);
        this.add(cid, totalScore);
    }

    public void clean(String cid) {
        if (StringUtils.isBlank((String)cid)) {
            return;
        }
        this.redisClient.opsForZSet().remove((Object)this.dataKey, new Object[]{cid});
    }
}

