package cn.com.duiba.activity.center.api.dto.wanda;

import cn.com.duiba.activity.center.api.params.PageParams;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达开票记录查询对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class WandaTaxTicketRecordQueryDto extends PageParams implements Serializable {
    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 开发者用户ID
     */
    private String uid;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 诺诺流水号
     */
    private String seriesNo;

    /**
     * 处理状态 0 初始化 1 开票中 2 开票成功 3 开票失败
     */
    private Integer handleStatus;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;
}