package cn.com.duiba.activity.center.api.remoteservice.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.NgameMutiRankingRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by sty on 12/10/17.
 */
@AdvancedFeignClient
public interface RemoteNgameMutiRankingRecordService {

    /**
     * 插入一条记录
     * @param ngameMutiRankingRecordDto
     * @return
     */
    NgameMutiRankingRecordDto insert(NgameMutiRankingRecordDto ngameMutiRankingRecordDto);

    /**
     * 查询记录
     * @param ngameMutiRankingRecordDto
     * @return
     */
    NgameMutiRankingRecordDto findByCidAndAppIdAndConfigId(NgameMutiRankingRecordDto ngameMutiRankingRecordDto);

    /**
     * 更新用户的总分
     * @param ngameMutiRankingRecordDto
     * @return
     */
    int updateTotalScore(NgameMutiRankingRecordDto ngameMutiRankingRecordDto);

    /**
     * 分页获取某个排行榜的信息
     * @param configId 排行榜配置id
     * @param appId appId
     * @return List<NgameMutiRankingRecordDto>
     */
    List<NgameMutiRankingRecordDto> listByConfigIdAndAppId(Long configId, Long appId);

}
