package cn.com.duiba.activity.center.api.remoteservice.shuqi;

import cn.com.duiba.activity.center.api.dto.BizResultDto;
import cn.com.duiba.activity.center.api.dto.shuqipk.PkTeamInfoDto;
import cn.com.duiba.activity.center.api.enums.ShuQiPKRecordTypeEnum;
import cn.com.duiba.api.bo.page.PageQuery;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2018/12/27 19:47
 * @description:
 */
@AdvancedFeignClient
public interface RemotePkTeamInfoService {
    /**
     * 新建战队，同时战队成员也会有记录，战队记录里面会有记录，阅读值+10
     * @param dto 战队信息
	 * @param consumerId 创建人
     * @return
     */
    void insert(PkTeamInfoDto dto, Long consumerId) throws BizException;

	/**
     * 查询战队名称是否存在
     * @param teamName
     * @return
     */
    Boolean teamNameExist(String teamName);

	/**
	 * 批量更新阅读值
	 * @param infos
	 * @return
	 */
	BizResultDto batchUpdateReadValue(List<PkTeamInfoDto> infos);

	/**
	 * 根据战队id获取战队信息
	 */
	PkTeamInfoDto getById(Long teamId);

    /**
     * 分页获取战队列表
	 * 没有设置缓存，仅供定时任务调用
     * @param page
     * @return
     */
    List<PkTeamInfoDto> getTeamPage(PageQuery page);

	/**
	 * 根据战队id list批量查询战队信息
	 */
	List<PkTeamInfoDto> getListByIds(List<Long> teamIdList);

	/**
	 * 添加阅读值，同时成员记录也会新增一条记录，排行榜也会累计
	 * @param teamInfoDto 战队信息
	 * @param readValue 本次加的阅读值
	 * @param recordType 阅读值类型
	 * @throws BizException 业务异常
	 * @return 操作结果
	 */
	Boolean addReadValue(PkTeamInfoDto teamInfoDto, Long readValue, ShuQiPKRecordTypeEnum recordType) throws BizException;
}
