package cn.com.duiba.activity.center.api.params.activitychannel;

import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * <p>活动渠道通用配置参数</p>
 * <p>created by Xuwei on 2021/4/12<p>
 **/
public abstract class BaseActivityChannelParam implements Serializable {

    private static final long serialVersionUID = 8988148490666842655L;

    /** 是否选择 */
    @JSONField(name = "sel")
    private boolean selected;
    /** 是否分享页引导打开/下载APP */
    @JSONField(name = "spg")
    private Boolean sharePageGuide;

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Boolean getSharePageGuide() {
        return sharePageGuide;
    }

    public void setSharePageGuide(Boolean sharePageGuide) {
        this.sharePageGuide = sharePageGuide;
    }

    /**
     * 参数校验
     * @throws BizException 业务异常
     */
    public void check() throws BizException {
        if (selected) {
            checkSelected();
        } else {
            checkUnselected();
        }
    }

    /**
     * 选择时参数校验
     * @throws BizException
     */
    protected void checkSelected() throws BizException {
        if (sharePageGuide == null) {
            throw new BizException("是否分享页引导打开/下载APP不能为空");
        }
    }

    /**
     * 未选择时参数校验
     */
    protected void checkUnselected() throws BizException {
    }
}
