package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaGroupBuyingAuditOrderDto;
import cn.com.duiba.activity.center.api.params.wanda.WandaGroupBuyingAuditOrderParam;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 万达酒店集采审核订单远程服务接口
 */
@AdvancedFeignClient
public interface RemoteWandaGroupBuyingAuditOrderService {
    /**
     * 添加审核订单
     */
    Integer insert(WandaGroupBuyingAuditOrderDto auditOrderDto);

    /**
     * 根据查询参数分页查询审核订单列表
     */
    Page<WandaGroupBuyingAuditOrderDto> listWandaGroupBuyingAuditOrder(WandaGroupBuyingAuditOrderParam  param);

    /**
     * 审核订单
     */
    Boolean doAudit(String orderNum, Integer auditSatus, String auditDesc);

    /**
     * 审核订单
     */
    Boolean updateAuditDesc(String orderNum, String auditDesc);

    /**
     * 根据订单号orderNum获取审核订单
     */
    WandaGroupBuyingAuditOrderDto findByOrderNum(String orderNum);

    /**
     * 通过审核状态查询审核订单数量
     */
    Integer countByAuditStatus(Integer auditStatus);

}