package cn.com.duiba.activity.center.api.dto.hsbc;

import lombok.Data;
import java.util.Date;

/**
 * 汇丰定制-机会商品订单 实体类
 * @author huakai
 * @date 2024/05/25
 */
@Data
public class HsbcChanceOrderDto {

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 汇丰订单号
     */
    private String merchantOrderId;
    
    /**
     * 应用id
     */
    private Long appId;
    
    /**
     * 用户id
     */
    private Long consumerId;
    
    /**
     * 机会商品id
     */
    private Long chanceItemId;
    
    /**
     * 关联活动id
     */
    private Long associatedActivityId;
    
    /**
     * 消耗积分
     */
    private Integer consumeCredits;
    
    /**
     * 有效期开始时间
     */
    private Date useBeginTime;
    
    /**
     * 有效期结束时间
     */
    private Date useEndTime;

    /**
     * 关联的兑换记录id
     */
    private Long associatedExchangeRecordId;

    /**
     * 关联的订单id
     */
    private Long associatedOrderId;
    
    /**
     * 使用状态
     * 1：未使用；2：未领取；3：已完成（未中奖）；4：已完成（已中奖已领取）；5 已超时（超时未领取）
     */
    private Integer useStatus;
    
    /**
     * 订单状态
     * init 初始化 success 成功 false 失败
     */
    private String orderStatus;
    
    /**
     * 创建时间
     */
    private Date gmtCreate;
    
    /**
     * 修改时间
     */
    private Date gmtModified;
}