package cn.com.duiba.activity.center.api.dto.singlelottery;

import cn.com.duiba.activity.center.api.dto.BaseActivityDto;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/6/20.
 */
public class AppSingleLotteryDto extends BaseActivityDto implements Serializable{

    private static final long serialVersionUID = 6246528175238187774L;

    public static final String CONSUMER_DRAW_LIMIT_FOREVER = "forever";
    public static final String CONSUMER_DRAW_LIMIT_EVERYDAY = "everyday";

    public static final String FREE_LIMIT_FOREVER = "forever";
    public static final String FREE_LIMIT_EVERYDAY = "everyday";

    private Long id;

    private Long appId;

    private Long mainAppItemId; // 主奖品app_item_id

    private String mainAppItemDegree; // 主奖品档位

    private String mainAppItemRate; // 主奖品中奖率

    private String title; // 活动标题

    private Integer consumerDrawLimit; // 用户抽奖数限制

    private String consumerDrawLimitScope; // 用户抽奖数限制 每天/全局

    private Integer freeLimit; // 免费抽奖次数

    private String freeLimitScope; // 免费抽奖次数 每天/全局

    private Integer consumerWinLimit; // 用户中奖数限制

    private Integer everydayWinLimit; // 每日中奖限制

    private Integer mainAppItemRemaining; // 主奖品数量

    private Integer credits; // 抽奖积分

    private String logo; // 图标

    private String smallImage; // 缩略图

    private String image; // 详情图

    private String bannerImage; // 首页banner

    private String introduction; // 活动说明

    private String limitDateJson;// 限时抽奖,日期限制，时间限制，存放json

    private Boolean deleted;

    private Date gmtCreate;

    private Date gmtModified;

    private String rateIntroduction;	// 概率说明

    private Long vipLimits; //会员等级限制添加字段

    private Integer vipLimitType; //会员等级限制添加字段

    private Integer minComein;//大奖保底人数
    
    private String exchangeLimit;//商品防刷

    private Date startTime; // 活动开始日期
    
    private Date autoOffDate; //定时自动下架日期

    /**
     * 中奖信息轮播开关
     * 1 轮播 0 关闭
     */
    private Integer rotation;

    /**
     * 扩展信息
     */
    private String extendJson;

    public Integer getRotation() {
        return rotation;
    }

    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    /**
     *
     * Creates a new instance of AppSingleLotteryDto.
     *
     */
    public AppSingleLotteryDto() {
        super();
    }

    /**
     *
     * Creates a new instance of AppSingleLotteryDto.
     *
     * @param id
     */
    public AppSingleLotteryDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     *
     * Creates a new instance of AppSingleLotteryDto.
     *
     * @param init4insert
     */
    public AppSingleLotteryDto(boolean init4insert) {
        if (init4insert) {
            deleted = false;
            vipLimits = 0L;
            vipLimitType = 0;
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getExchangeLimit() {
		return exchangeLimit;
	}

	public void setExchangeLimit(String exchangeLimit) {
		this.exchangeLimit = exchangeLimit;
	}

    @Override
    public String toString() {
        return "AppSingleLotteryDO [id=" + id + ", title=" + title + "]";
    }



    public String getRateIntroduction() {
        return rateIntroduction;
    }

    public void setRateIntroduction(String rateIntroduction) {
        this.rateIntroduction = rateIntroduction;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMainAppItemId() {
        return mainAppItemId;
    }

    public void setMainAppItemId(Long mainAppItemId) {
        this.mainAppItemId = mainAppItemId;
    }

    public String getMainAppItemDegree() {
        return mainAppItemDegree;
    }

    public void setMainAppItemDegree(String mainAppItemDegree) {
        this.mainAppItemDegree = mainAppItemDegree;
    }

    public String getMainAppItemRate() {
        return mainAppItemRate;
    }

    public void setMainAppItemRate(String mainAppItemRate) {
        this.mainAppItemRate = mainAppItemRate;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getConsumerDrawLimit() {
        return consumerDrawLimit;
    }

    public void setConsumerDrawLimit(Integer consumerDrawLimit) {
        this.consumerDrawLimit = consumerDrawLimit;
    }

    public String getConsumerDrawLimitScope() {
        return consumerDrawLimitScope;
    }

    public void setConsumerDrawLimitScope(String consumerDrawLimitScope) {
        this.consumerDrawLimitScope = consumerDrawLimitScope;
    }

    public Integer getFreeLimit() {
        return freeLimit;
    }

    public void setFreeLimit(Integer freeLimit) {
        this.freeLimit = freeLimit;
    }

    public String getFreeLimitScope() {
        return freeLimitScope;
    }

    public void setFreeLimitScope(String freeLimitScope) {
        this.freeLimitScope = freeLimitScope;
    }

    public Integer getConsumerWinLimit() {
        return consumerWinLimit;
    }

    public void setConsumerWinLimit(Integer consumerWinLimit) {
        this.consumerWinLimit = consumerWinLimit;
    }

    public Integer getEverydayWinLimit() {
        return everydayWinLimit;
    }

    public void setEverydayWinLimit(Integer everydayWinLimit) {
        this.everydayWinLimit = everydayWinLimit;
    }

    public Integer getMainAppItemRemaining() {
        return mainAppItemRemaining;
    }

    public void setMainAppItemRemaining(Integer mainAppItemRemaining) {
        this.mainAppItemRemaining = mainAppItemRemaining;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public String getLimitDateJson() {
        return limitDateJson;
    }

    public void setLimitDateJson(String limitDateJson) {
        this.limitDateJson = limitDateJson;
    }

    public Long getVipLimits() {
        return vipLimits;
    }

    public void setVipLimits(Long vipLimits) {
        this.vipLimits = vipLimits;
    }

    public Integer getVipLimitType() {
        return vipLimitType;
    }

    public void setVipLimitType(Integer vipLimitType) {
        this.vipLimitType = vipLimitType;
    }

    public Integer getMinComein() {
        return minComein;
    }

    public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public void setMinComein(Integer minComein) {
        this.minComein = minComein;
    }

    public String getExtendJson() {
        return extendJson;
    }

    public void setExtendJson(String extendJson) {
        this.extendJson = extendJson;
    }
}
