package cn.com.duiba.activity.center.api.enums.alipayactivityredpack;

import java.util.Objects;

public enum RedpackCouponSourceEnum {
    ALIPAY(0, "支付宝立减金"),
    WECHAT(1, "微信立减金"),
    WECHAT_RED(2, "微信红包"),
    ;

    private Integer code;
    private String status;

    public String getStatus() {
        return status;
    }

    public Integer getCode() {
        return code;
    }

    RedpackCouponSourceEnum(Integer code, String status) {
        this.code = code;
        this.status = status;
    }

    public static RedpackCouponSourceEnum ofValue(Integer code) {
        for (RedpackCouponSourceEnum drawStatusEnum : values()) {
            if (Objects.equals(drawStatusEnum.getCode(), code)) {
                return drawStatusEnum;
            }
        }
        return null;
    }
}
