package cn.com.duiba.activity.center.api.enums.hsbc;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 使用状态 1：未使用；2：未领取；3：已完成（未中奖）；4：已完成（已中奖已领取）；5 已超时（超时未领取）
 */
@Getter
public enum HsbcChanceOrderUseStatusEnum {
    UNUSED(1, "未使用"),
    UN_RECEIVE(2, "未领取"),
    COMPLETED_NOT_WIN(3, "已完成（未中奖）"),
    COMPLETED_WIN_RECEIVED(4, "已完成（已中奖已领取）"),
    TIMEOUT_NOT_RECEIVE(5, "已超时（超时未领取）");


    private final int code;
    private final String desc;

    HsbcChanceOrderUseStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
