package cn.com.duiba.activity.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.center.api.dto.hsbc.HsbcHdtoolTaskPrizeDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: LuHui
 * @date: 2023/11/6 11:54
 * @description:
 */
@AdvancedFeignClient
public interface RemoteHsbcHdtoolTaskPrizeService {


    /**
     * 根据活动Id删除奖品
     * @param operatingActivityId
     * @return
     */
    int deleteByActId(Long operatingActivityId);

    /**
     * 批量插入
     * @param prizeList
     * @return
     */
    int batchInsert(List<HsbcHdtoolTaskPrizeDto> prizeList) throws BizException;

    /**
     * 根据活动和任务id查询奖品
     * @param operatingActivityId
     * @param taskId
     * @return
     */
    List<HsbcHdtoolTaskPrizeDto> findByActAndTaskId(Long operatingActivityId, Long taskId);

    /**
     * 根据活动id查询奖品
     * @param operatingActivityId
     * @return
     */
    List<HsbcHdtoolTaskPrizeDto> findByActId(Long operatingActivityId);


    /**
     * 自减奖品库存
     * @param id
     * @return
     */
    int decrPrizeStock(Long id);

    /**
     * 自增奖品库存
     * @param id
     * @return
     */
    int incrPrizeStock(Long id);

    /**
     * 查询奖品
     * @param operatingActivityId 活动ID
     * @param taskId 任务id
     * @param bizId 区间id
     * @param appItemId 商品ID
     * @return
     */
    HsbcHdtoolTaskPrizeDto findOnePrize(Long operatingActivityId, Long taskId, String bizId, Long appItemId);
}
