package cn.com.duiba.activity.center.api.enums.creditsfarm;

/**
 * @Author chenxiangge
 * @Date 2019/8/9
 */
public enum SeedTypeEnum {

    /**
     * 种子类型：apple-苹果 potato-土豆 rice-大米 peanut-花生
     */
    APPLE(1, "苹果"),
    POTATO(2, "土豆"),
    RICE(3, "大米"),
    PEANUT(4, "花生"),
    ;


    private Integer code;
    private String desc;

    SeedTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SeedTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SeedTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
