package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 权益类型枚举类
 * @author: Simba
 * @create: 2019-08-05 15:27
 **/
public enum EquityTypeEnum {
    MATCH_EXCHANGE(1, "匹配兑换码兑换"),
    CONFIG_EXCHANGE(2, "配置兑换码及权益兑换"),
    MATCH_IDENTITY(3, "匹配用户身份核销"),

    ;
    private Integer code;
    private String desc;

    EquityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EquityTypeEnum ofValue(Integer code) {
        for (EquityTypeEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

