package cn.com.duiba.activity.center.api.dto.app_survey;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @description 开发者问卷题库
 * @author huakai
 * @date 2024-07-30
 */
@Data
public class AppSurveyLibraryDto implements Serializable {

    private static final long serialVersionUID = 1L;
    
    /**
    * 主键
    */
    private Long id;

    /**
    * 开发者应用id
    */
    private Long appId;

    /**
    * 题库名称
    */
    private String title;

    /**
    * 是否删除 0 未删除 1 已删除
    */
    private Integer deleted;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 问卷题目列表
     */
    private List<AppSurveyQuestionDto> questionConfigList;

    public AppSurveyLibraryDto() {}
}