package cn.com.duiba.activity.center.api.remoteservice.guessredpacket;

import cn.com.duiba.activity.center.api.dto.guessredpacket.RedPacketGuessRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/3/27 11:07
 */
@AdvancedFeignClient
public interface RemoteRedPacketGuessRecordService {

    /**
     * 插入记录
     * @param dto
     * @return
     */
    Long insert(RedPacketGuessRecordDto dto);

    /**
     * 红包被猜记录
     * @param redPacketId 红包ID
     * @return
     */
    List<RedPacketGuessRecordDto> selectByPacketId(Long redPacketId);

    /**
     * 批量更新猜红包记录
     * @param dtos
     * @return
     */
    Boolean batchUpdateRecord(List<RedPacketGuessRecordDto> dtos);

    /**
     * 单条更新猜红包记录
     * @param dto
     * @return
     */
    Boolean updateRecord(RedPacketGuessRecordDto dto);

    /**
     * 查询用户猜红包记录
     * @param consumerId 用户ID
     * @return 猜红包记录
     */
    List<RedPacketGuessRecordDto> getConsumerGuessRecord(Long consumerId);
}
