package cn.com.duiba.activity.center.api.domain.dto.grantgood;

import cn.com.duiba.boot.exception.BizException;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @Description
 * @Date 2023/3/23 17:10
 * @Author LuHui
 */
public enum GoodGrantStatusEnum {
    INIT(0,"初始化"),
    PROCESS(1,"处理中"),
    SUCCESS(2,"成功"),
    FAIL(3,"失败"),

    ;

    private Integer status;

    private String desc;

    GoodGrantStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static GoodGrantStatusEnum getByStatus(Integer status) {
        return Stream.of(GoodGrantStatusEnum.values()).filter(x -> Objects.equals(x.getStatus(), status)).findFirst().orElse(null);
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
