package cn.com.duiba.activity.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.center.api.dto.hsbc.HsbcChanceConfigDto;
import cn.com.duiba.activity.center.api.params.hsbc.HsbcChanceConfigPageParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author: LuHui
 * @date: 2024/5/24 18:22
 * @description:
 */
@AdvancedFeignClient
public interface RemoteHsbcChanceConfigService {

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    Page<HsbcChanceConfigDto> selectByPage(HsbcChanceConfigPageParam param);

    /**
     * 根据主键id查询
     *
     * @param id
     * @return
     */
    HsbcChanceConfigDto selectById(Long id);

    /**
     * 根据机会名称查询
     *
     * @param chanceName
     * @return
     */
    @Deprecated
    HsbcChanceConfigDto selectByChanceName(String chanceName);

    /**
     * 根据机会名称查询
     *
     * @param appId
     * @param chanceName
     * @return
     */
    HsbcChanceConfigDto selectByName(Long appId, String chanceName);

    /**
     * 保存
     *
     * @param hsbcChanceConfigDto
     * @return
     */
    int save(HsbcChanceConfigDto hsbcChanceConfigDto);

    /**
     * 更新
     *
     * @param hsbcChanceConfigDto
     * @return
     */
    int updateById(HsbcChanceConfigDto hsbcChanceConfigDto);

    /**
     * 逻辑删除
     *
     * @param id
     * @return
     */
    int logicDeleteById(Long id);
}
