package cn.com.duiba.activity.center.api.remoteservice.lottery;

import cn.com.duiba.activity.center.api.dto.lottery.LotteryBetDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/05/31
 */

@AdvancedFeignClient
public interface RemoteLotteryBetBackendService {
    /**
     * 获取分页信息
     */
    Page<LotteryBetDto> getLotteryBetPageApi(Integer pageNo, Integer pageSize);

    /**
     * 根据博彩投注活动id获取活动详情
     */
    LotteryBetDto getById(Long id);

    /**
     * 保存详情
     */
    Boolean save(LotteryBetDto lotteryBetDto);

    /**
     * 更新详情
     * @param lotteryBetDto
     * @return
     */
    Boolean modify(LotteryBetDto lotteryBetDto);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 修改活动结算状态（开奖或退单）
     */
    Boolean updateBetStatus(Long id,Long betResultId,String resultDesc, Integer status);
}
