package cn.com.duiba.activity.center.api.remoteservice.projectx;

import cn.com.duiba.activity.center.api.dto.projectx.HdtoolProjectTemplateDto;
import cn.com.duiba.activity.center.api.params.TemplateListParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by hong
 * time 2022/8/10.
 */
@AdvancedFeignClient
public interface RemoteHdtoolProjectTemplateService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return FAQ类别集合
     */
    List<HdtoolProjectTemplateDto> selectList(TemplateListParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Integer selectCount(TemplateListParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return FAQ类别
     */
    HdtoolProjectTemplateDto selectById(Long id);

    /**
     * 新增
     * @param entity FAQ类别
     * @return 执行结果
     */
    Long insert(HdtoolProjectTemplateDto entity);

    /**
     * 更新
     * @param entity FAQ类别
     * @return 执行结果
     */
    Boolean update(HdtoolProjectTemplateDto entity);

    /**
     * 根据条件查询
     * @param param 查询条件
     * @return FAQ类别集合
     */
    Page<HdtoolProjectTemplateDto> selectPage(TemplateListParam param);

    /**
     * 添加兑吧星速台模板活动到cms
     */
    Long addDuibaProjectxTemplateToDeveloper(Long appId, Long projectTemplateId);

    /**
     * 根据id集合获取列表
     */
    List<HdtoolProjectTemplateDto> selectByIds(List<Long> ids);
}
