package cn.com.duiba.activity.center.api.remoteservice.quizz;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * Created by xuezhaoming on 16/6/13.
 */
@AdvancedFeignClient
public interface RemoteDuibaQuizzServiceInner {

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<DuibaQuizzDto> find(Long id);
	
    /**
     * 
     * findTagById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
	public String findTagById(Long id);

	/**
	 * 
	 * findByPage:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param offset
	 * @param max
	 * @return
	 * @since JDK 1.6
	 */
    @RequestMapping("/findByPage1")
    DubboResult<List<DuibaQuizzDto>> findByPage(Integer offset, Integer max);

    /**
     * 
     * findPageCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> findPageCount(Map<String, Object> paramMap);

    /**
     * 
     * findByPage:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<DuibaQuizzDto>> findByPage(Map<String, Object> paramMap);

    /**
     * 
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param status
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateStatus(Long id, int status);

    /**
     * 
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> delete(Long id);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzDto
     * @return
     * @since JDK 1.6
     */
    DubboResult<DuibaQuizzDto> insert(DuibaQuizzDto duibaQuizzDto);

    /**
     * 
     * updateInfoForm:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzDto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateInfoForm(DuibaQuizzDto duibaQuizzDto);
    /**
     * 
     * updateTagById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param tag
     * @return
     * @since JDK 1.6
     */
	public int updateTagById(Long id, String tag);

	/**
	 * 
	 * updateAutoOffDateNull:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
    DubboResult<Integer> updateAutoOffDateNull(Long id);

    /**
     * 
     * updateSwitches:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param switches
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateSwitches(Long id, Long switches);

    /**
     * 
     * findAutoOff:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<DuibaQuizzDto>> findAutoOff();

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<DuibaQuizzDto>> findAllByIds(List<Long> ids);

    /**
     * 
     * findAllQuizz:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AddActivityDto>> findAllQuizz();

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * @param duibaQuizzDto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> update(DuibaQuizzDto duibaQuizzDto);

    //from DuibaQuizzServiceImpl

    public DubboResult<Long> addDuibaQuizzToDeveloper(Long appId, Long duibaQuizzId);

    /**
     * 关闭并可见
     *
     */
    public DubboResult<Void> updateStatusCloseShow(DuibaQuizzDto quizz);


    /**
     * from DuibaQuizzCtrl
     * @param quizzId
     * @param status
     */
    public DubboResult<Void> updateBannerAndAppItem(Long quizzId, Integer status);

    //from AdminQuizzManagerImpl in manager
    public DubboResult<Void> addDuibaQuizzAppSpecify(Long id, String[] appIds);
}
